--
-- Configuration der DB2 fr Federated Data vorbereiten.
-- 

UPDATE DBM CFG USING FEDERATED YES

--
-- DB Server stoppen und wieder starten
-- Falls domino oder sonst eine Datenbank aktiv ist, muss dies manuell, entweder ber
-- db2stop
-- db2start
-- oder in Windows ber die Toolbar
-- oder ber
-- stop database manager;
-- start database manager; 
-- in der Befehlskonsole
-- 


--
-- Verbindung zur Domino Datenbank herstellen
-- User DB2ADMIN = User mit administrativen Rechen
-- 

CONNECT TO DOMINO USER DB2ADMIN USING *****;

--
-- Erzeugen eines sogenannten Wrapper, der externe Datenquellen zur Verfgung stellen kann
-- Name DRDA frei whlbar
--

CREATE WRAPPER DRDA LIBRARY 'db2drda.dll' OPTIONS( ADD DB2_FENCED 'N');

--
-- Erzeugen der Verbindung zum externen Server
-- SERVER SAMPLE => SAMPLE = Neuer Name fr die entfernte Datenbank
-- DRDA (s.o.)
-- remote_user = User, der auf die entfernte Datenbank zugreifen darf
-- ADD DBNAME 'SAMPLE' => SAMPLE ist der Name der entfernten Datenbank die referenziert werden soll.

CREATE SERVER SAMPLE TYPE DB2/UDB VERSION '8.2' WRAPPER DRDA AUTHID "remote_user" PASSWORD "****" OPTIONS( ADD DBNAME 'SAMPLE', PASSWORD 'Y');

--
-- Erzeugen eines Benutzermappings, der es ermglicht, einen lokalen Benutzer auf einen entfernten Benutzer 
-- abzubilden und dort unter dessen Rechen auf die entfernte Datenbank zuzugreifen.
-- DB2ADMIN = lokaler user
-- remote_user = entferter user, der verwendet wird, wenn lokal der user DB2ADMIN angemeldet ist (User Mapping)
-- 

CREATE USER MAPPING FOR "DB2ADMIN" SERVER "SAMPLE" OPTIONS ( ADD REMOTE_AUTHID 'remote_user', ADD  REMOTE_PASSWORD '****') ;

-- 
-- Erzeugen eines Mappings fr einen entfernten Tabellennamen, damit die entfernte Tabelle unter
-- einem sinnvollen lokalen Namen ansprechbar ist.
-- NICKNAME DB2ADMIN.DEPARTMENT = Lokaler Name fr die entfernte Datenbank
-- SAMPLE.TOMTOM_E.DEPARTMENT = Name der entfernten Datenbank

CREATE NICKNAME DB2ADMIN.DEPARTMENT FOR SAMPLE.remote_user.DEPARTMENT;